function [S,S1,S2]=VSM(A,B)

%
% [S,S1,S2]=VSM(A,B)
%
% To compute the similarity between two IT2 FSs A and B using the VSM:
% 
% D. Wu and Jerry M. Mendel, "A vector similarity measure for linguistic 
% approximation: Interval type-2 and type-1 fuzzy sets," Information 
% Sciences, vol. 178, no. 2, pp. 381--402, 2008.
%
% Dongrui WU (dongruiw@usc.edu), 7/9/2008
%
% A, B: IT2 FSs each defined by nine parameters (see Fig. 1 in Readme.doc)
% 
% S: The crisp similarity
% S1, S2: Two components of the VSM

CA=centroidIT2(A);
CB=centroidIT2(B);

dAB=CB-CA;
B(1:8)=B(1:8)-dAB;
minX=min(A(1),B(1)); % the range
maxX=max(A(4),B(4));

N=200; % number of discretizations
X=linspace(minX,maxX,N);

lowerA=mg(X,A(5:8),[0 A([9 9]) 0]);
upperA=mg(X,A(1:4));
lowerB=mg(X,B(5:8),[0 B([9 9]) 0]);
upperB=mg(X,B(1:4));

S1=sum([min([upperA;upperB]), min([lowerA;lowerB])])/...
    sum([max([upperA;upperB]), max([lowerA;lowerB])]);
S2=exp(-4*abs(dAB)/(maxX-minX));
S=S1*S2;


